package com.els.tso.auth.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;

/**
 * <p>
 * 权限表
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-05
 */
@TableName("platform_permission")
public class Permission extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 权限名称
     */
    private String permissionName;

    /**
     * 权限描述
     */
    private String description;

    /**
     * 权限路径
     */
    private String permissionUrl;

    /**
     * 权限标识
     */
    private String permissionPerms;

    /**
     * 父级权限id
     */
    private String parentId;

    /**
     * 类型   0：目录   1：菜单   2：按钮
     */
    private String permissionType;

    /**
     * 排序
     */
    private String orderNum;

    /**
     * 图标
     */
    private String icon;


    public String getPermissionName() {
        return permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPermissionUrl() {
        return permissionUrl;
    }

    public void setPermissionUrl(String permissionUrl) {
        this.permissionUrl = permissionUrl;
    }

    public String getPermissionPerms() {
        return permissionPerms;
    }

    public void setPermissionPerms(String permissionPerms) {
        this.permissionPerms = permissionPerms;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String toString() {
        return "Permission{" +
        "permissionName=" + permissionName +
        ", description=" + description +
        ", permissionUrl=" + permissionUrl +
        ", permissionPerms=" + permissionPerms +
        ", parentId=" + parentId +
        ", permissionType=" + permissionType +
        ", orderNum=" + orderNum +
        ", icon=" + icon +
        "}";
    }
}
