package com.els.tso.auth.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.els.tso.auth.entity.Permission;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 权限表 服务类
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-05
 */
public interface IPermissionService extends IService<Permission> {
    /**
     * Shiro初始化加载权限
     * 加在ShiroService中造成循环引用
     * @return
     */
    Map<String ,String> initShrioFilterChainDefinitionMap();
    /**
     * 获取全部角色对应的权限
     * @return
     */
    List<Permission> getAllRolePermission();

    /**
     * 根据角色ID获取角色对应的权限
     * @param roleID
     * @return
     */
    List<Permission> getPermissionByRoleID(String roleID);

    /**
     * 根据用户ID获取用户对应的权限
     * @param userID
     * @return
     */
    List<Permission> getPermissionByUserID(String userID);

}
