package com.els.tso.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.tso.auth.dao.PermissionDAO;
import com.els.tso.auth.entity.*;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IRolePermissionService;
import com.els.tso.auth.service.IRoleService;
import com.els.tso.auth.service.IUserRoleService;
import com.els.tso.auth.utils.ShiroHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>
 * 权限表 服务实现类
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-05
 */
@Service
public class PermissionServiceImpl extends ServiceImpl<PermissionDAO, Permission> implements IPermissionService {

    @Autowired
    private IRoleService roleService;
    @Autowired
    private IRolePermissionService rolePermissionService;
    @Autowired
    private IUserRoleService userRoleService;

    @Override
    public Map<String, String> initShrioFilterChainDefinitionMap() {
        Map<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        //静态资源拦截
        filterChainDefinitionMap.putAll(ShiroHelper.staticFilterMap);
        //权限资源拦截
        getAllRolePermission().forEach((p) ->
            //perms验证
            filterChainDefinitionMap.put(p.getPermissionUrl().concat("/**"), "perms[" + p.getId() + "]")
        );
        return filterChainDefinitionMap;
    }

    @Override
    public List<Permission> getAllRolePermission() {
        LinkedHashSet<Permission> hashSet = new LinkedHashSet<>();
        roleService.list().forEach((role) ->
            getPermissionByRoleID(role.getId() + "").
                forEach((p) ->
                    hashSet.add(p)
                )
        );
        LinkedList<Permission> permissions = new LinkedList<>();
        permissions.addAll(hashSet);
        return permissions;
    }

    @Override
    public List<Permission> getPermissionByRoleID(String roleID) {
        LinkedHashSet<Permission> hashSet = new LinkedHashSet<>();
        List<RolePermission> rolePermissionList = rolePermissionService.list(new QueryWrapper<>(new RolePermission(roleID
            , null)));
        rolePermissionList.forEach((rolePermission) -> {
            Permission permission = getById(rolePermission.getPermissionId());
            if (permission != null) {
                hashSet.add(permission);
            }
        });
        LinkedList<Permission> permissions = new LinkedList<>();
        permissions.addAll(hashSet);
        return permissions;
    }

    @Override
    public List<Permission> getPermissionByUserID(String userID) {
        List<UserRole> userRoles = userRoleService.list(new QueryWrapper<>(new UserRole(userID, null)));
        LinkedHashSet<Permission> hashSet = new LinkedHashSet<>();
        userRoles.forEach((userRole) -> {
            getPermissionByRoleID(userRole.getRoleId()).forEach((p) -> {
                hashSet.add(p);
            });
        });
        LinkedList<Permission> permissions = new LinkedList<>();
        permissions.addAll(hashSet);
        return permissions;
    }
}
