package com.els.tso.auth.aop;

import com.els.tso.auth.service.IShiroService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Aspect
@Component
public class ResetRolePermissionAspect {
    @Autowired
    private IShiroService shiroService;
    private static final Logger logger = LoggerFactory.getLogger(ResetRolePermissionAspect.class);

   /* @Pointcut("execution (public * com.els.tso..controller..*(..))")
    public void permissionAspect() {
    }*/

    @AfterReturning("@annotation(com.els.tso.auth.annotation.ResetRolePermission)")
    public void afterReturn(JoinPoint joinPoint) {
        //刷新shiro权限
        shiroService.resetShrioFilterChainDefinitionMap();
    }


}
