package com.els.tso.auth.controller;


import com.els.tso.auth.entity.Role;
import com.els.tso.auth.service.IRoleService;
import com.els.tso.common.dto.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色表 tso前端控制器
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-06
 */
@RestController
@RequestMapping("/role")
public class RoleController {
    @Autowired
    private IRoleService roleService;

    /**
     * 更新或新增
     *
     * @param role
     * @return
     */
    @PostMapping("/save")
    public R<?> add(@RequestBody Role role) {
        return R.ok(roleService.saveOrUpdate(role));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {
        return R.ok(roleService.removeById(id));
    }

}

