package com.els.tso.auth.controller;


import com.els.tso.auth.annotation.ResetRolePermission;
import com.els.tso.auth.annotation.ResetUserPermission;
import com.els.tso.auth.entity.RolePermission;
import com.els.tso.auth.service.IRolePermissionService;
import com.els.tso.common.dto.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色权限表 tso前端控制器
 * 增、删、改操作方法需加注解：
 * @ResetRolePermission：刷新shiro权限列表
 * @ResetUserPermission：刷新redis权限缓存
 * 返回为R<RolePermission>
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-06
 */
@RestController
@RequestMapping("/rolePermission")
public class RolePermissionController {
    @Autowired
    private IRolePermissionService rolePermissionService;

    /**
     * 更新或新增
     *
     * @param rolePermission
     * @return
     */
    @PostMapping("/save")
    @ResetRolePermission
    @ResetUserPermission
    public R<RolePermission> add(@RequestBody RolePermission rolePermission) {
        rolePermissionService.saveOrUpdate(rolePermission);
        return R.ok(rolePermission);
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    @ResetRolePermission
    @ResetUserPermission
    public R<RolePermission> delete(Long id) {
        RolePermission rolePermission = rolePermissionService.getById(id);
        rolePermissionService.removeById(id);
        return R.ok(rolePermission);
    }


}

