package com.els.tso.auth.controller;


import com.els.tso.auth.annotation.ResetUserPermission;
import com.els.tso.auth.entity.RolePermission;
import com.els.tso.auth.entity.UserRole;
import com.els.tso.auth.service.IUserRoleService;
import com.els.tso.common.dto.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 用户角色表 tso前端控制器
 * 增、删、改操作方法需加注解：
 * @ResetUserPermission：刷新redis权限缓存
 * 返回为R<UserRole>
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-06
 */
@RestController
@RequestMapping("/userRole")
public class UserRoleController {
    @Autowired
    private IUserRoleService userRoleService;

    /**
     * 更新或新增
     *
     * @param userRole
     * @return
     */
    @PostMapping("/save")
    @ResetUserPermission
    public R<UserRole> add(@RequestBody UserRole userRole) {
        userRoleService.saveOrUpdate(userRole);
        return R.ok(userRole);
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    @ResetUserPermission
    public R<UserRole> delete(Long id) {
        UserRole userRole = userRoleService.getById(id);
        userRoleService.removeById(id);
        return R.ok(userRole);
    }

}

