package com.els.tso.auth.filter;

import com.alibaba.fastjson.JSONObject;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.base.util.ContextUtil;
import com.els.tso.base.util.JwtUtil;
import com.els.tso.common.constant.SystemConstant;
import com.els.tso.common.dto.AccountBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author fanyilei
 */
@WebFilter(urlPatterns = {"/*"})
@Order(Ordered.HIGHEST_PRECEDENCE)
public class ContextFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    @Autowired
    private RedisCacheService redisCacheService;

    private final static int expire = 30 * 60 * 1000;

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
        throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse res = (HttpServletResponse) response;
        String token = req.getHeader(SystemConstant.TOKEN);
        if (token != null) {
            String userId = JwtUtil.validToken(token);
            Object userObj = redisCacheService.get(userId);
            AccountBO accountBO;
            if (userObj == null) {
                accountBO = ContextUtil.getAccountBO(userId);
                redisCacheService.setWithExpire(userId, JSONObject.toJSONString(accountBO), expire);
            } else {
                accountBO = JSONObject.parseObject(userObj.toString(), AccountBO.class);
            }
            ContextUtil.loginAccount(req, accountBO);
        }
        chain.doFilter(req, res);
    }

    @Override
    public void init(FilterConfig arg0) {

    }


}
