package com.els.tso.auth.utils;

import com.els.tso.auth.entity.Permission;
import org.springframework.util.CollectionUtils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author: fanyilei
 */
public class ShiroHelper {
    public static Map<String, String> staticFilterMap = new LinkedHashMap<String, String>();
    static {
        //anon 不校验
        staticFilterMap.put("/static/**", "anon");
        //authc需要登录
        staticFilterMap.put("/index/**", "authc");
    }
    public  static Set<String> getPermissionIdSetByPermissionList(List<Permission> permissions){
        if (CollectionUtils.isEmpty(permissions)){
            return null;
        }
        return permissions.stream().map(p -> p.getId().toString()).collect(Collectors.toSet());
    }

}
