/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.auth.aop;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.tso.auth.entity.Permission;
import com.els.tso.auth.entity.RolePermission;
import com.els.tso.auth.entity.UserRole;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IUserRoleService;
import com.els.tso.auth.utils.ShiroHelper;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.dto.R;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResetUserPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(ResetUserPermissionAspect.class);
    @Autowired
    private IPermissionService permissionService;
    @Autowired
    private RedisCacheService redisCacheService;
    @Autowired
    private IUserRoleService userRoleService;
    private static final Logger logger = LoggerFactory.getLogger(ResetUserPermissionAspect.class);

    @AfterReturning(returning="result", pointcut="@annotation(com.els.tso.auth.annotation.ResetUserPermission)")
    public void afterReturn(JoinPoint joinPoint, Object result) {
        if (R.class.equals(result.getClass())) {
            R RResult = (R)result;
            Object data = RResult.getData();
            if (UserRole.class.equals(data.getClass())) {
                UserRole userRole = (UserRole)((Object)data);
                this.setRedisPermissionByUserID(userRole.getUserId());
            }
            if (RolePermission.class.equals(data.getClass())) {
                RolePermission rolePermission = (RolePermission)((Object)data);
                List userRoleList = this.userRoleService.list((Wrapper)new QueryWrapper((Object)new UserRole(null, rolePermission.getRoleId())));
                userRoleList.forEach(t -> this.setRedisPermissionByUserID(t.getUserId()));
            }
        }
    }

    public void setRedisPermissionByUserID(String userID) {
        List<Permission> permissionList = this.permissionService.getPermissionByUserID(userID);
        Set<String> permissions = ShiroHelper.getPermissionIdSetByPermissionList(permissionList);
        this.redisCacheService.set((Object)("USER_PERMISSION_" + userID), permissions);
    }
}

