/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.auth.config;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.tso.auth.entity.Permission;
import com.els.tso.auth.entity.User;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IUserService;
import com.els.tso.auth.utils.ShiroHelper;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.constant.ResultEnum;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private IUserService iUserService;
    @Autowired
    private IPermissionService permissionService;
    @Autowired
    private RedisCacheService redisCacheService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String userCode = (String)principals.getPrimaryPrincipal();
        User user = this.getUserByCode(userCode);
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        Set set = (Set)this.redisCacheService.get((Object)("USER_PERMISSION_" + user.getId()));
        if (set != null && set.size() > 0) {
            authorizationInfo.setStringPermissions(set);
        } else {
            List<Permission> permissionList = this.permissionService.getPermissionByUserID(user.getId() + "");
            Set<String> permissions = ShiroHelper.getPermissionIdSetByPermissionList(permissionList);
            authorizationInfo.setStringPermissions(permissions);
            this.redisCacheService.set((Object)("USER_PERMISSION_" + user.getId()), permissions);
        }
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String userCode = (String)token.getPrincipal();
        User user = this.getUserByCode(userCode);
        Subject subject = SecurityUtils.getSubject();
        subject.getSession().setAttribute((Object)"user", (Object)user);
        return new SimpleAuthenticationInfo((Object)user.getUserCode(), (Object)user.getPassword(), ((Object)((Object)this)).getClass().getSimpleName());
    }

    public User getUserByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new AuthenticationException(ResultEnum.LOGIN_USERCODE_NOT_BLANK.getMessage());
        }
        User user = new User();
        user.setUserCode(code);
        QueryWrapper queryWrapper = new QueryWrapper((Object)user);
        user = (User)((Object)this.iUserService.getOne((Wrapper)queryWrapper));
        if (user == null) {
            throw new AuthenticationException(ResultEnum.LOGIN_AUDIT_FAIL.getMessage());
        }
        return user;
    }
}

