/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.auth.filter;

import com.alibaba.fastjson.JSONObject;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.base.util.ContextUtil;
import com.els.tso.base.util.JwtUtil;
import com.els.tso.common.dto.AccountBO;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@WebFilter(urlPatterns={"/*"})
@Order(value=-2147483648)
public class ContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    @Autowired
    private RedisCacheService redisCacheService;
    private static final int expire = 1800000;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String token = req.getHeader("token");
        if (token != null) {
            AccountBO accountBO;
            String userId = JwtUtil.validToken((String)token);
            Object userObj = this.redisCacheService.get((Object)userId);
            if (userObj == null) {
                accountBO = ContextUtil.getAccountBO((String)userId);
                this.redisCacheService.setWithExpire((Object)userId, (Object)JSONObject.toJSONString((Object)accountBO), 1800000L);
            } else {
                accountBO = (AccountBO)JSONObject.parseObject((String)userObj.toString(), AccountBO.class);
            }
            ContextUtil.loginAccount((HttpServletRequest)req, (AccountBO)accountBO);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void init(FilterConfig arg0) {
    }
}

