/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.tso.auth.dao.PermissionDAO;
import com.els.tso.auth.entity.Permission;
import com.els.tso.auth.entity.RolePermission;
import com.els.tso.auth.entity.UserRole;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IRolePermissionService;
import com.els.tso.auth.service.IRoleService;
import com.els.tso.auth.service.IUserRoleService;
import com.els.tso.auth.utils.ShiroHelper;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
extends ServiceImpl<PermissionDAO, Permission>
implements IPermissionService {
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IRolePermissionService rolePermissionService;
    @Autowired
    private IUserRoleService userRoleService;

    @Override
    public Map<String, String> initShrioFilterChainDefinitionMap() {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.putAll(ShiroHelper.staticFilterMap);
        this.getAllRolePermission().forEach(p -> filterChainDefinitionMap.put(p.getPermissionUrl().concat("/**"), "perms[" + p.getId() + "]"));
        return filterChainDefinitionMap;
    }

    @Override
    public List<Permission> getAllRolePermission() {
        LinkedHashSet hashSet = new LinkedHashSet();
        this.roleService.list().forEach(role -> this.getPermissionByRoleID(role.getId() + "").forEach(p -> hashSet.add(p)));
        LinkedList<Permission> permissions = new LinkedList<Permission>();
        permissions.addAll(hashSet);
        return permissions;
    }

    @Override
    public List<Permission> getPermissionByRoleID(String roleID) {
        LinkedHashSet hashSet = new LinkedHashSet();
        List rolePermissionList = this.rolePermissionService.list((Wrapper)new QueryWrapper((Object)new RolePermission(roleID, null)));
        rolePermissionList.forEach(rolePermission -> {
            Permission permission = (Permission)((Object)((Object)this.getById((Serializable)((Object)rolePermission.getPermissionId()))));
            if (permission != null) {
                hashSet.add(permission);
            }
        });
        LinkedList<Permission> permissions = new LinkedList<Permission>();
        permissions.addAll(hashSet);
        return permissions;
    }

    @Override
    public List<Permission> getPermissionByUserID(String userID) {
        List userRoles = this.userRoleService.list((Wrapper)new QueryWrapper((Object)new UserRole(userID, null)));
        LinkedHashSet hashSet = new LinkedHashSet();
        userRoles.forEach(userRole -> this.getPermissionByRoleID(userRole.getRoleId()).forEach(p -> hashSet.add(p)));
        LinkedList<Permission> permissions = new LinkedList<Permission>();
        permissions.addAll(hashSet);
        return permissions;
    }
}

