/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.auth.service.impl;

import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IShiroService;
import java.util.Map;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ShiroServiceImpl
implements IShiroService {
    @Autowired
    private IPermissionService permissionService;
    @Autowired
    @Qualifier(value="shiroFilter")
    private ShiroFilterFactoryBean shiroFilterFactoryBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetShrioFilterChainDefinitionMap() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = this.shiroFilterFactoryBean;
        synchronized (shiroFilterFactoryBean) {
            AbstractShiroFilter shiroFilter;
            try {
                shiroFilter = (AbstractShiroFilter)this.shiroFilterFactoryBean.getObject();
            }
            catch (Exception e) {
                throw new RuntimeException("get ShiroFilter from shiroFilterFactoryBean error!");
            }
            PathMatchingFilterChainResolver filterChainResolver = (PathMatchingFilterChainResolver)shiroFilter.getFilterChainResolver();
            DefaultFilterChainManager manager = (DefaultFilterChainManager)filterChainResolver.getFilterChainManager();
            manager.getFilterChains().clear();
            this.shiroFilterFactoryBean.getFilterChainDefinitionMap().clear();
            this.shiroFilterFactoryBean.setFilterChainDefinitionMap(this.permissionService.initShrioFilterChainDefinitionMap());
            Map chains = this.shiroFilterFactoryBean.getFilterChainDefinitionMap();
            for (Map.Entry entry : chains.entrySet()) {
                String url = (String)entry.getKey();
                String chainDefinition = ((String)entry.getValue()).trim().replace(" ", "");
                manager.createChain(url, chainDefinition);
            }
        }
    }
}

