/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.aop;

import com.alibaba.fastjson.JSON;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.dto.AccountBO;
import com.els.tso.common.util.SnowflakeIdUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ControllerAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerAspect.class);
    private static final Logger logger = LoggerFactory.getLogger(ControllerAspect.class);
    @Autowired
    private RedisCacheService redisCacheService;

    @Pointcut(value="execution (public * com.els.tso..controller..*(..))")
    public void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.getRequestMsg(joinPoint, request, "Before");
    }

    @Around(value="controllerAspect()")
    public Object around(JoinPoint joinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        Object result = ((ProceedingJoinPoint)joinPoint).proceed();
        long end = System.currentTimeMillis();
        logger.info("Around " + joinPoint + "\t cost : " + (end - start) + " ms");
        return result;
    }

    @After(value="controllerAspect()")
    public void after(JoinPoint joinPoint) {
    }

    @AfterReturning(value="controllerAspect()")
    public void afterReturn(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.delCommitID(request);
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        String commitID = SnowflakeIdUtil.getId() + "";
        response.setHeader("commitID", commitID);
    }

    @AfterThrowing(pointcut="controllerAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.delCommitID(request);
        this.getRequestMsg(joinPoint, request, "Exception");
        String params = this.getParams(joinPoint);
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement stackTraceElement = stackTrace[0];
        int lineNumber = stackTraceElement.getLineNumber();
        logger.error("ExceptionController:[{}],ExceptionMethod:[{}],ExceptionCode:[{}],ExceptionMessage:[{}],ExceptionLineNumber:[{}]ExceptionArgs:[{}]", new Object[]{joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), e.getClass().getName(), e.getMessage(), lineNumber, params});
    }

    private void getRequestMsg(JoinPoint joinPoint, HttpServletRequest request, String type) {
        HttpSession session = request.getSession();
        AccountBO accountBO = (AccountBO)session.getAttribute("LoginInfo");
        String userName = "";
        if (accountBO != null) {
            userName = accountBO.getUsername();
        }
        String ip = request.getRemoteAddr();
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        String params = this.getParams(joinPoint);
        logger.info(type + " Log: User:[{}],UserIP:[{}],ControllerClass:[{}],Method:[{}],Args:[{}]", new Object[]{userName, ip, className, methodName, params});
    }

    private String getParams(JoinPoint joinPoint) {
        String params = "";
        Object[] args = joinPoint.getArgs();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    params = params + JSON.toJSONString((Object)args[i]) + ",";
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return params;
    }

    private void delCommitID(HttpServletRequest request) {
        String reqCommitID = request.getHeader("commitID");
        if (reqCommitID != null) {
            this.redisCacheService.del(reqCommitID);
        }
    }
}

