/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.aop;

import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.exception.BusinessException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class PreventResubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(PreventResubmitAspect.class);
    private static final Logger logger = LoggerFactory.getLogger(PreventResubmitAspect.class);
    @Autowired
    private RedisCacheService redisCacheService;

    @Before(value="@annotation(com.els.tso.base.annotation.PreventResubmit)")
    public synchronized void doBefore(JoinPoint joinPoint) {
        String commitID;
        Object idObj;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request.getHeader("commitID") != null && (idObj = this.redisCacheService.get(commitID = request.getHeader("commitID"))) == null) {
            throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        }
        this.delCommitID(request);
    }

    @Around(value="@annotation(com.els.tso.base.annotation.PreventResubmit)")
    public Object around(JoinPoint joinPoint) throws Throwable {
        Object proceed = ((ProceedingJoinPoint)joinPoint).proceed();
        return proceed;
    }

    private void delCommitID(HttpServletRequest request) {
        String reqCommitID = request.getHeader("commitID");
        if (reqCommitID != null) {
            this.redisCacheService.del(reqCommitID);
        }
    }
}

