/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.els.tso.base.interceptor.TsoMybatisPlusInterceptor;
import com.els.tso.common.dto.UserPrincipal;
import com.els.tso.common.util.AuthPrincipalHolder;
import java.time.LocalDateTime;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.apache.ibatis.reflection.MetaObject;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@MapperScan(value={"com.els.**.dao"})
public class MybatisPlusConfig {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        TsoMybatisPlusInterceptor interceptor = new TsoMybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                UserPrincipal user = AuthPrincipalHolder.getUser();
                if (user == null) {
                    return new LongValue(2L);
                }
                return new LongValue(user.getTenantId().longValue());
            }

            public String getTenantIdColumn() {
                return "tenant_id";
            }

            public boolean ignoreTable(String tableName) {
                return !tableName.startsWith("system_");
            }
        }));
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean
    public MybatisMetaObjectHandler mybatisMetaObjectHandler() {
        return new MybatisMetaObjectHandler();
    }

    @Bean
    @Profile(value={"test"})
    public MybatisPlusInterceptor mybatisPlusDevInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor());
        return interceptor;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> configuration.setUseDeprecatedExecutor(false);
    }

    private static class MybatisMetaObjectHandler
    implements MetaObjectHandler {
        private MybatisMetaObjectHandler() {
        }

        public void insertFill(MetaObject metaObject) {
            Optional<UserPrincipal> opt = Optional.ofNullable(AuthPrincipalHolder.getUser());
            String userCode = opt.map(UserPrincipal::getUserCode).orElse("admin");
            LocalDateTime now = LocalDateTime.now();
            this.setFieldValByName("createAt", now, metaObject);
            this.setFieldValByName("modifyAt", now, metaObject);
            this.setFieldValByName("modifyBy", userCode, metaObject);
            this.setFieldValByName("createBy", userCode, metaObject);
        }

        public void updateFill(MetaObject metaObject) {
            Optional<UserPrincipal> opt = Optional.ofNullable(AuthPrincipalHolder.getUser());
            String userCode = opt.map(UserPrincipal::getUserCode).orElse("admin");
            LocalDateTime now = LocalDateTime.now();
            this.setFieldValByName("modifyAt", now, metaObject);
            this.setFieldValByName("modifyBy", userCode, metaObject);
        }
    }
}

