/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.constant;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PropertiesEnum {
    INSTANCE;

    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String fileName) {
        Properties properties = null;
        InputStreamReader propertyIn = null;
        try {
            String propertiesPath = "properties/";
            String filePath = propertiesPath + fileName;
            if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath) != null) {
                propertyIn = new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath)), StandardCharsets.UTF_8);
                properties = new Properties();
                properties.load(propertyIn);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (propertyIn != null) {
                try {
                    propertyIn.close();
                }
                catch (IOException e) {
                    LOGGER.error("close Exception", (Throwable)e);
                }
            }
        }
        return properties;
    }

    public Properties getSysProperties() {
        return this.getProperties("sysconfig.properties");
    }

    public Properties getPublicKeysProperties() {
        return this.getProperties("publicKeys.properties");
    }

    public Properties getOssProperties() {
        return this.getProperties("oss.properties");
    }

    public Properties getSsoProperties() {
        return this.getProperties("sso.properties");
    }

    public Properties getI18nProperties() {
        return this.getProperties("i18nInit.properties");
    }

    public Properties getRedisProperties() {
        return this.getProperties("redis.properties");
    }

    static {
        LOGGER = LoggerFactory.getLogger(PropertiesEnum.class);
    }
}

