/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.interceptor;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.els.tso.common.exception.OptimisticLockerException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class TsoMybatisPlusInterceptor
extends MybatisPlusInterceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object newVersionValue;
        int iResult;
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        boolean isUpdate = args.length == 2;
        Object et = null;
        Object oldVersionValue = null;
        if (isUpdate) {
            et = this.getEntity(invocation);
            oldVersionValue = this.getVersionValue(et);
        }
        Object result = super.intercept(invocation);
        if (isUpdate && et != null && oldVersionValue != null && result instanceof Integer && (iResult = ((Integer)result).intValue()) <= 0 && !oldVersionValue.equals(newVersionValue = this.getVersionValue(et))) {
            throw new OptimisticLockerException("\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u88ab\u66f4\u65b0!");
        }
        return result;
    }

    private Object getEntity(Invocation invocation) {
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (target instanceof Executor) {
            Executor executor = (Executor)target;
            Object parameter = args[1];
            Object tableInfo = null;
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                return map.getOrDefault("et", null);
            }
        }
        return null;
    }

    private Object getVersionValue(Object entity) {
        try {
            if (entity == null) {
                return null;
            }
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
            Object result = null;
            if (tableInfo != null && tableInfo.isWithVersion()) {
                TableFieldInfo fieldInfo = tableInfo.getVersionFieldInfo();
                Field versionField = fieldInfo.getField();
                return versionField.get(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

