/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.service.impl;

import com.els.tso.base.dao.ColumnsMapper;
import com.els.tso.base.pojo.entity.ColumnsEntity;
import com.els.tso.base.pojo.query.TableDataCopyQuery;
import com.els.tso.base.service.CopyByElsAccountService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class CopyByElsAccountServiceImpl
implements CopyByElsAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyByElsAccountServiceImpl.class);
    private static final String ELS_ACCOUNT = "elsAccount";
    private static final String UUID = "uuid";
    private static final String ID = "id";
    private static final String SEPARATOR = ",";
    private static final String UUID_FUNCTION = "uuid()";
    @Resource
    private ColumnsMapper columnsMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tableDataCopy(TableDataCopyQuery query) {
        List<ColumnsEntity> columnsEntities = this.columnsMapper.selectColumnsByTableName(query.getTableSchema(), query.getTableNames());
        LinkedMultiValueMap map = new LinkedMultiValueMap(32);
        columnsEntities.forEach(arg_0 -> CopyByElsAccountServiceImpl.lambda$tableDataCopy$0((MultiValueMap)map, arg_0));
        ArrayList sqlList = new ArrayList();
        map.forEach((key, value) -> {
            StringBuilder columnBuilder = new StringBuilder();
            StringBuilder valueBuilder = new StringBuilder();
            value.forEach(column -> {
                if (!ID.equalsIgnoreCase(column.getColumnName())) {
                    valueBuilder.append(SEPARATOR);
                    columnBuilder.append(SEPARATOR);
                    columnBuilder.append(this.backQuote(column.getColumnName()));
                    if (ELS_ACCOUNT.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append(this.quote("\"" + query.getToElsAccount() + "\""));
                    } else if (UUID.equalsIgnoreCase(column.getColumnName())) {
                        valueBuilder.append(this.quote("\"uuid()\""));
                    } else {
                        valueBuilder.append(this.ifNull(this.quote(this.backQuote(column.getColumnName()))));
                    }
                }
            });
            String columnStr = columnBuilder.toString().substring(1);
            String valueStr = valueBuilder.toString().substring(1);
            sqlList.add(String.format("SELECT concat_ws(\"%s\",\"INSERT %s (%s) VALUES(\",%s,\");\") sqlstr FROM %s WHERE elsAccount = \"%s\"", SEPARATOR, key, columnStr, valueStr, key, query.getFromElsAccount()));
        });
        String enterpriseInfoSql = "INSERT INTO `enterprise_info` (`uuid`, `elsAccount`, `toElsAccount`, `fullName`, `shortName`, `nature`, `countryCode`, `province`, `city`, `address`, `telphone`, `fax`, `email`, `webSite`, `industry`, `industryDetail`, `erpCode`, `sexElsAccount`, `secondIndustry`, `publicSupply`, `publicClient`, `businessRegisterNo`, `organizationNo`, `businessLicence`, `preChangeData`, `category`, `socialCreditCode`, `registerCapital`, `registerDate`, `ledgerSubject`, `addedValueTaxNumber`, `supplierAccountGroup`, `supplierAccountGroupName`, `legalRepresentative`, `generalManager`, `introducer`, `isListed`, `paymentMethod`, `paymentClause`, `openingBank`, `mnemonicCode`, `affiliatingArea`, `taxCode`, `taxRate`, `currency`, `fullEnglishName`, `createDate`, `createUser`, `lastUpdateDate`, `lastUpdateUser`, `extendFields`, `fbk1`, `fbk2`, `fbk3`, `fbk4`, `fbk5`, `fbk6`, `fbk7`, `fbk8`, `fbk9`, `fbk10`, `fbk11`, `fbk12`, `fbk13`, `fbk14`, `fbk15`, `fbk16`, `fbk17`, `fbk18`, `fbk19`, `fbk20`, `fbk21`, `fbk22`, `fbk23`, `fbk24`, `fbk25`, `fbk26`, `fbk27`, `fbk28`, `fbk29`, `fbk30`, `fbk31`, `fbk32`, `fbk33`, `fbk34`, `fbk35`, `fbk36`, `fbk37`, `fbk38`, `fbk39`, `fbk40`) VALUES (uuid(), '%s', '%s', '%s', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '91110111MA017BX30L', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-12-09 00:00:00', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);\n";
        String subAccountSqlAdmin = "INSERT INTO `els_subaccount_info` (`elsAccount`, `elsSubAccount`, `elsSubAccountPassword`, `isAdmin`, `station`, `name`, `email`, `telphone1`, `telphone2`, `fax`, `nickname`, `employeeNumber`, `createDate`, `createUser`, `lastUpdateDate`, `lastUpdateUser`, `qqAccount`, `wxAccount`, `failTryTimes`, `frozenFlag`, `frozenDatetime`, `accountValidityDate`, `isDel`, `language`, `job`, `loginTime`, `unionId`, `address`, `portalAccount`, `associationClassify`, `materialCate`, `userType`, `fbk1`, `fbk2`, `fbk3`, `fbk4`, `fbk5`, `fbk6`, `fbk7`, `fbk8`, `fbk9`, `fbk10`) VALUES ('%s', '1001', '202cb962ac59075b964b07152d234b70', 'Y', 'purchase', '\u7ba1\u7406\u5458', NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, '2020-12-09 00:00:00', '1001_\u7ba1\u7406\u5458', NULL, NULL, '00', 'N', NULL, '2099-12-31', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);\n";
        String subAccountSqlConfig = "INSERT INTO `els_subaccount_info` (`elsAccount`, `elsSubAccount`, `elsSubAccountPassword`, `isAdmin`, `station`, `name`, `email`, `telphone1`, `telphone2`, `fax`, `nickname`, `employeeNumber`, `createDate`, `createUser`, `lastUpdateDate`, `lastUpdateUser`, `qqAccount`, `wxAccount`, `failTryTimes`, `frozenFlag`, `frozenDatetime`, `accountValidityDate`, `isDel`, `language`, `job`, `loginTime`, `unionId`, `address`, `portalAccount`, `associationClassify`, `materialCate`, `userType`, `fbk1`, `fbk2`, `fbk3`, `fbk4`, `fbk5`, `fbk6`, `fbk7`, `fbk8`, `fbk9`, `fbk10`) VALUES ('%s', 'config-user', 'a2e4fde83453739a08823799af695e6c', 'Y', 'purchase', '\u7ba1\u7406\u5458', NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, '2020-12-09 00:00:00', '1001_\u7ba1\u7406\u5458', NULL, NULL, '00', 'N', NULL, '2099-12-31', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);\n";
        String updateUfloSql = "        update els_app\n        set appUrl = \"https://cs.51qqt.com/" + query.getAppContext() + "/uflo/designer\"\n        where elsAccount = \"%s\"\n          and appCode = \"uflo_designer\";\n";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("set @@autocommit=0;\n");
        sqlList.forEach(item -> {
            List<String> resultList = this.columnsMapper.executeSelectSql((String)item);
            resultList.forEach(item2 -> sqlBuilder.append((String)item2).append("\n"));
        });
        sqlBuilder.append(String.format(updateUfloSql, query.getToElsAccount()));
        sqlBuilder.append(String.format(enterpriseInfoSql, query.getToElsAccount(), query.getToElsAccount(), query.getEnterpriseName()));
        sqlBuilder.append(String.format(subAccountSqlAdmin, query.getToElsAccount()));
        sqlBuilder.append(String.format(subAccountSqlConfig, query.getToElsAccount()));
        sqlBuilder.append("commit;\n");
        sqlBuilder.append("set @@autocommit=1;\n");
        query.getTableNames().add("els_subaccount_info");
        query.getTableNames().add("enterprise_info");
        String clearSql = this.tableDataClear(query);
        try (FileWriter sqlDataCopyWriter = new FileWriter(new File(String.format("D:/%s_data.sql", query.getToElsAccount())));
             FileWriter sqlDataClearWriter = new FileWriter(new File(String.format("D:/%s_data_rollback.sql", query.getToElsAccount())));){
            sqlDataCopyWriter.write(this.sqlReplaceAll(sqlBuilder.toString()));
            sqlDataClearWriter.write(clearSql);
            sqlDataCopyWriter.flush();
            sqlDataClearWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("sql\u6570\u636e\u751f\u6210\u5f02\u5e38;", (Throwable)e);
        }
    }

    private String tableDataClear(TableDataCopyQuery query) {
        StringBuilder clearSqlBuilder = new StringBuilder();
        String clearDataSql = " delete from %s where elsAccount = \"%s\";\n";
        query.getTableNames().forEach(tableName -> clearSqlBuilder.append(String.format(clearDataSql, tableName, query.getToElsAccount())));
        return clearSqlBuilder.toString();
    }

    private String quote(String str) {
        return "quote(" + str + ")";
    }

    private String ifNull(String column) {
        return "ifnull(" + column + ",\"NULL\")";
    }

    private String backQuote(String column) {
        return "`" + column + "`";
    }

    private String sqlReplaceAll(String str) {
        return str.replace(this.quote("NULL"), "NULL").replaceAll("VALUES\\(,", "VALUES(").replaceAll(",\\);", ");").replaceAll("'uuid\\(\\)'", UUID_FUNCTION);
    }

    private static /* synthetic */ void lambda$tableDataCopy$0(MultiValueMap map, ColumnsEntity co) {
        map.add((Object)co.getTableName(), (Object)co);
    }
}

