/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.base.service.TokenService;
import com.els.tso.base.util.JwtUtil;
import com.els.tso.common.dto.AccountBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
implements TokenService {
    @Autowired
    private RedisCacheService redisCacheService;

    @Override
    public String validToken(String token) {
        return JwtUtil.validToken(token);
    }

    @Override
    public String createToken(String elsAccount, String elsSubAccount) throws Exception {
        AccountBO accountBO;
        String tokenKey = "Token#" + elsAccount + "_" + elsSubAccount;
        Object accountObj = this.redisCacheService.get(tokenKey);
        if (accountObj == null) {
            accountBO = JwtUtil.initJWTToken(elsAccount + "_" + elsSubAccount, new AccountBO());
            this.redisCacheService.setWithExpire(tokenKey, JSONObject.toJSONString((Object)accountBO), accountBO.getTokenExpires() - System.currentTimeMillis());
        } else {
            accountBO = (AccountBO)JSONObject.parseObject((String)accountObj.toString(), AccountBO.class);
        }
        return accountBO.getToken();
    }
}

