/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.base.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.els.tso.base.util.SysPropertisUtil;
import com.els.tso.common.dto.AccountBO;
import com.els.tso.common.exception.LoginAuditException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    private static final String JWT_SECRET = SysPropertisUtil.getStringAndDecrypt("jwt_secret");
    private static final String JWT_ISSUER = SysPropertisUtil.getString("jwt_issuer");
    private static final Algorithm ALGORITHM = Algorithm.HMAC256((String)JWT_SECRET);
    private static final JWTVerifier JWT_VERIFIER = JWT.require((Algorithm)ALGORITHM).withIssuer(JWT_ISSUER).build();
    private static final long TOKEN_EXPIRES_TIME = SysPropertisUtil.getLong("jwt_expires") * 1000L;
    private static final long REFRESH_TOKEN_EXPIRES_TIME = TOKEN_EXPIRES_TIME * 2L;
    private static final long TOLERANCE_TIME = 30000L;

    public static String validToken(String token) throws LoginAuditException {
        try {
            DecodedJWT decodedJWT = JWT_VERIFIER.verify(token);
            Claim claimAccount = decodedJWT.getClaim("account");
            if (claimAccount == null) {
                throw new LoginAuditException("\u8ba4\u8bc1\u5931\u8d25\uff01\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u8d26\u53f7\u4fe1\u606f\uff01");
            }
            return claimAccount.asString();
        }
        catch (Exception e) {
            log.error("ElsJwtUtil.validToken", (Throwable)e);
            throw new LoginAuditException("\u8ba4\u8bc1\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
    }

    public static void main(String[] args) throws Exception {
    }

    public static AccountBO initJWTToken(String elsAccount_elsSubAccount, AccountBO accountBO) throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        long tokenExpires = currentTimeMillis + TOKEN_EXPIRES_TIME;
        long refreshTokenExpires = currentTimeMillis + REFRESH_TOKEN_EXPIRES_TIME;
        String token = JWT.create().withIssuer(JWT_ISSUER).withExpiresAt(new Date(tokenExpires)).withClaim("account", elsAccount_elsSubAccount).sign(ALGORITHM);
        String refreshToken = JWT.create().withIssuer(JWT_ISSUER).withExpiresAt(new Date(refreshTokenExpires)).withClaim("account", elsAccount_elsSubAccount).sign(ALGORITHM);
        accountBO.setToken(token);
        accountBO.setTokenExpires(Long.valueOf(tokenExpires));
        accountBO.setRefreshToken(refreshToken);
        accountBO.setRefreshTokenExpires(Long.valueOf(refreshTokenExpires));
        return accountBO;
    }
}

