package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Catalog;
import com.els.tso.system.query.CatalogQuery;
import com.els.tso.system.service.ICatalogService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 组织类别 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/catalog")
public class CatalogController {

    private final ICatalogService catalogService;

    public CatalogController(ICatalogService catalogService) {
        this.catalogService = catalogService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody CatalogQuery query) {

        //查询条件
        QueryWrapper<Catalog> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Catalog.class));
        //分页条件
        Page<Catalog> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(catalogService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(catalogService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param catalog
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Catalog catalog) {

        return R.ok(catalogService.saveOrUpdate(catalog));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(catalogService.removeById(id));
    }
}

