package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Menu;
import com.els.tso.system.query.MenuQuery;
import com.els.tso.system.service.IMenuService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 菜单表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/menu")
public class MenuController {

    private final IMenuService menuService;

    public MenuController(IMenuService menuService) {
        this.menuService = menuService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody MenuQuery query) {

        //查询条件
        QueryWrapper<Menu> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Menu.class));
        //分页条件
        Page<Menu> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(menuService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(menuService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param menu
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Menu menu) {

        return R.ok(menuService.saveOrUpdate(menu));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(menuService.removeById(id));
    }
}

