package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Organization;
import com.els.tso.system.query.OrganizationQuery;
import com.els.tso.system.service.IOrganizationService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 公司、部门组织表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/organization")
public class OrganizationController {

    private final IOrganizationService organizationService;

    public OrganizationController(IOrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody OrganizationQuery query) {

        //查询条件
        QueryWrapper<Organization> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Organization.class));
        //分页条件
        Page<Organization> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(organizationService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(organizationService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param organization
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Organization organization) {

        return R.ok(organizationService.saveOrUpdate(organization));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(organizationService.removeById(id));
    }
}

