package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Permission;
import com.els.tso.system.query.PermissionQuery;
import com.els.tso.system.service.IPermissionService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 权限对象表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/permission")
public class PermissionController {

    private final IPermissionService permissionService;

    public PermissionController(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody PermissionQuery query) {

        //查询条件
        QueryWrapper<Permission> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Permission.class));
        //分页条件
        Page<Permission> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(permissionService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(permissionService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param permission
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Permission permission) {

        return R.ok(permissionService.saveOrUpdate(permission));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(permissionService.removeById(id));
    }
}

