package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Post;
import com.els.tso.system.query.PostQuery;
import com.els.tso.system.service.IPostService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 岗位表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/post")
public class PostController {

    private final IPostService postService;

    public PostController(IPostService postService) {
        this.postService = postService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody PostQuery query) {

        //查询条件
        QueryWrapper<Post> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Post.class));
        //分页条件
        Page<Post> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(postService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(postService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param post
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Post post) {

        return R.ok(postService.saveOrUpdate(post));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(postService.removeById(id));
    }
}

