package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.PostRole;
import com.els.tso.system.query.PostRoleQuery;
import com.els.tso.system.service.IPostRoleService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色用户关联表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/post-role")
public class PostRoleController {

    private final IPostRoleService postRoleService;

    public PostRoleController(IPostRoleService postRoleService) {
        this.postRoleService = postRoleService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody PostRoleQuery query) {

        //查询条件
        QueryWrapper<PostRole> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, PostRole.class));
        //分页条件
        Page<PostRole> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(postRoleService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(postRoleService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param postRole
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody PostRole postRole) {

        return R.ok(postRoleService.saveOrUpdate(postRole));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(postRoleService.removeById(id));
    }
}

