package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.PostStaff;
import com.els.tso.system.query.PostStaffQuery;
import com.els.tso.system.service.IPostStaffService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 岗位员工关联表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/post-staff")
public class PostStaffController {

    private final IPostStaffService postStaffService;

    public PostStaffController(IPostStaffService postStaffService) {
        this.postStaffService = postStaffService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody PostStaffQuery query) {

        //查询条件
        QueryWrapper<PostStaff> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, PostStaff.class));
        //分页条件
        Page<PostStaff> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(postStaffService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(postStaffService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param postStaff
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody PostStaff postStaff) {

        return R.ok(postStaffService.saveOrUpdate(postStaff));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(postStaffService.removeById(id));
    }
}

