package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Role;
import com.els.tso.system.query.RoleQuery;
import com.els.tso.system.service.IRoleService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/role")
public class RoleController {

    private final IRoleService roleService;

    public RoleController(IRoleService roleService) {
        this.roleService = roleService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody RoleQuery query) {

        //查询条件
        QueryWrapper<Role> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Role.class));
        //分页条件
        Page<Role> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(roleService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(roleService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param role
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Role role) {

        return R.ok(roleService.saveOrUpdate(role));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(roleService.removeById(id));
    }
}

