package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.RolePermission;
import com.els.tso.system.query.RolePermissionQuery;
import com.els.tso.system.service.IRolePermissionService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色权限表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/role-permission")
public class RolePermissionController {

    private final IRolePermissionService rolePermissionService;

    public RolePermissionController(IRolePermissionService rolePermissionService) {
        this.rolePermissionService = rolePermissionService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody RolePermissionQuery query) {

        //查询条件
        QueryWrapper<RolePermission> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, RolePermission.class));
        //分页条件
        Page<RolePermission> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(rolePermissionService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(rolePermissionService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param rolePermission
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody RolePermission rolePermission) {

        return R.ok(rolePermissionService.saveOrUpdate(rolePermission));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(rolePermissionService.removeById(id));
    }
}

