package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.Staff;
import com.els.tso.system.query.StaffQuery;
import com.els.tso.system.service.IStaffService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 员工档案表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/staff")
public class StaffController {

    private final IStaffService staffService;

    public StaffController(IStaffService staffService) {
        this.staffService = staffService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody StaffQuery query) {

        //查询条件
        QueryWrapper<Staff> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, Staff.class));
        //分页条件
        Page<Staff> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(staffService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(staffService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param staff
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody Staff staff) {

        return R.ok(staffService.saveOrUpdate(staff));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(staffService.removeById(id));
    }
}

