package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.User;
import com.els.tso.system.query.UserQuery;
import com.els.tso.system.service.IUserService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 系统用户表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/user")
public class UserController {

    private final IUserService userService;

    public UserController(IUserService userService) {
        this.userService = userService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody UserQuery query) {

        //查询条件
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, User.class));
        //分页条件
        Page<User> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(userService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(userService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param user
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody User user) {

        return R.ok(userService.saveOrUpdate(user));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(userService.removeById(id));
    }
}

