package com.els.tso.system.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.tso.base.util.ConvertUtil;
import com.els.tso.common.dto.R;
import com.els.tso.system.entity.UserRole;
import com.els.tso.system.query.UserRoleQuery;
import com.els.tso.system.service.IUserRoleService;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 角色用户关联表 前端控制器
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@RestController
@RequestMapping("/system/user-role")
public class UserRoleController {

    private final IUserRoleService userRoleService;

    public UserRoleController(IUserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    /**
     * 条件查询
     *
     * @param query
     * @return
     */
    @PostMapping("/list")
    public R<?> list(@RequestBody UserRoleQuery query) {

        //查询条件
        QueryWrapper<UserRole> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(ConvertUtil.copy(query, UserRole.class));
        //分页条件
        Page<UserRole> page = new Page<>(query.getPageNum(), query.getPageSize());
        //查询返回
        return R.ok(userRoleService.page(page, queryWrapper));
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> get(Long id) {

        return R.ok(userRoleService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param userRole
     * @return
     */
    @PostMapping("/save")
    public R<?> save(@RequestBody UserRole userRole) {

        return R.ok(userRoleService.saveOrUpdate(userRole));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {

        return R.ok(userRoleService.removeById(id));
    }
}

