package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 组织类别
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_catalog")
@ApiModel(value = "Catalog对象", description = "组织类别")
public class Catalog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "组织类型编码")
    private String catalogCode;

    @ApiModelProperty(value = "组织类型名称")
    private String catalogName;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;


    public String getCatalogCode() {
        return catalogCode;
    }

    public void setCatalogCode(String catalogCode) {
        this.catalogCode = catalogCode;
    }

    public String getCatalogName() {
        return catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Catalog{" +
            "catalogCode=" + catalogCode +
            ", catalogName=" + catalogName +
            ", disabled=" + disabled +
            "}";
    }
}
