package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 公司、部门组织表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_organization")
@ApiModel(value = "Organization对象", description = "公司、部门组织表")
public class Organization extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "父级组织id")
    private Long parentId;

    @ApiModelProperty(value = "组织类别")
    private Long catalogId;

    @ApiModelProperty(value = "顺序号")
    private Integer order;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getCatalogId() {
        return catalogId;
    }

    public void setCatalogId(Long catalogId) {
        this.catalogId = catalogId;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Organization{" +
            "orgCode=" + orgCode +
            ", orgName=" + orgName +
            ", parentId=" + parentId +
            ", catalogId=" + catalogId +
            ", order=" + order +
            ", disabled=" + disabled +
            "}";
    }
}
