package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 权限对象表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_permission")
@ApiModel(value = "Permission对象", description = "权限对象表")
public class Permission extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "权限编码")
    private String permissionCode;

    @ApiModelProperty(value = "权限名称")
    private String permissionName;

    @ApiModelProperty(value = "权限类型(1菜单,2接口,3操作元素)")
    private Integer permissionType;

    @ApiModelProperty(value = "资源id")
    private Long resourceId;


    public String getPermissionCode() {
        return permissionCode;
    }

    public void setPermissionCode(String permissionCode) {
        this.permissionCode = permissionCode;
    }

    public String getPermissionName() {
        return permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public String toString() {
        return "Permission{" +
            "permissionCode=" + permissionCode +
            ", permissionName=" + permissionName +
            ", permissionType=" + permissionType +
            ", resourceId=" + resourceId +
            "}";
    }
}
