package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 岗位表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_post")
@ApiModel(value = "Post对象", description = "岗位表")
public class Post extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private Long organizationId;

    @ApiModelProperty(value = "岗位编码")
    private String postCode;

    @ApiModelProperty(value = "岗位名称")
    private String postName;

    @ApiModelProperty(value = "上级岗位id")
    private Long parentId;

    @ApiModelProperty(value = "是否负责人岗位(1负责人,0普通岗位)")
    @TableField("is_leader")
    private Boolean leader;

    @ApiModelProperty(value = "顺序号")
    private Integer order;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;


    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeader() {
        return leader;
    }

    public void setLeader(Boolean leader) {
        this.leader = leader;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Post{" +
            "organizationId=" + organizationId +
            ", postCode=" + postCode +
            ", postName=" + postName +
            ", parentId=" + parentId +
            ", leader=" + leader +
            ", order=" + order +
            ", disabled=" + disabled +
            "}";
    }
}
