package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 角色表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_role")
@ApiModel(value = "Role对象", description = "角色表")
public class Role extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    @ApiModelProperty(value = "权限名称")
    private String roleName;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;


    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Role{" +
            "roleCode=" + roleCode +
            ", roleName=" + roleName +
            ", disabled=" + disabled +
            "}";
    }
}
