package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 员工档案表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_staff")
@ApiModel(value = "Staff对象", description = "员工档案表")
public class Staff extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "岗位id")
    private Long postId;

    @ApiModelProperty(value = "员工工号")
    private String staffNumber;

    @ApiModelProperty(value = "员工姓名")
    private String staffName;

    @ApiModelProperty(value = "是否主要岗位(1主岗,2兼职)")
    @TableField("is_main_post")
    private Boolean mainPost;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "手机号")
    private String phone;

    @ApiModelProperty(value = "男1,女2")
    private Integer sex;

    @ApiModelProperty(value = "在职1(不包含试用期员工),离职2,实习3,试用4")
    private Integer jobStatus;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;


    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getStaffNumber() {
        return staffNumber;
    }

    public void setStaffNumber(String staffNumber) {
        this.staffNumber = staffNumber;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public Boolean getMainPost() {
        return mainPost;
    }

    public void setMainPost(Boolean mainPost) {
        this.mainPost = mainPost;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(Integer jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Staff{" +
            "postId=" + postId +
            ", staffNumber=" + staffNumber +
            ", staffName=" + staffName +
            ", mainPost=" + mainPost +
            ", email=" + email +
            ", phone=" + phone +
            ", sex=" + sex +
            ", jobStatus=" + jobStatus +
            ", disabled=" + disabled +
            "}";
    }
}
