package com.els.tso.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.els.tso.base.core.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;

/**
 * <p>
 * 系统用户表
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
@TableName("system_user")
@ApiModel(value = "User对象", description = "系统用户表")
public class User extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "大B账号")
    private String elsAccount;

    @ApiModelProperty(value = "子账号")
    private String elsSubAccount;

    @ApiModelProperty(value = "用户密码")
    private String password;

    @ApiModelProperty(value = "员工id")
    private Long staffId;

    @ApiModelProperty(value = "是否管理员(0不是,1是)")
    @TableField("is_admin")
    private Boolean admin;

    @ApiModelProperty(value = "是否禁用(0未禁用,1禁用)")
    private Boolean disabled;

    @ApiModelProperty(value = "有效期开始时间")
    private LocalDateTime startValidDatetime;

    @ApiModelProperty(value = "有效期结束时间")
    private LocalDateTime endValidDatetime;


    public String getElsAccount() {
        return elsAccount;
    }

    public void setElsAccount(String elsAccount) {
        this.elsAccount = elsAccount;
    }

    public String getElsSubAccount() {
        return elsSubAccount;
    }

    public void setElsSubAccount(String elsSubAccount) {
        this.elsSubAccount = elsSubAccount;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getStaffId() {
        return staffId;
    }

    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public Boolean getAdmin() {
        return admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public LocalDateTime getStartValidDatetime() {
        return startValidDatetime;
    }

    public void setStartValidDatetime(LocalDateTime startValidDatetime) {
        this.startValidDatetime = startValidDatetime;
    }

    public LocalDateTime getEndValidDatetime() {
        return endValidDatetime;
    }

    public void setEndValidDatetime(LocalDateTime endValidDatetime) {
        this.endValidDatetime = endValidDatetime;
    }

    @Override
    public String toString() {
        return "User{" +
            "elsAccount=" + elsAccount +
            ", elsSubAccount=" + elsSubAccount +
            ", password=" + password +
            ", staffId=" + staffId +
            ", admin=" + admin +
            ", disabled=" + disabled +
            ", startValidDatetime=" + startValidDatetime +
            ", endValidDatetime=" + endValidDatetime +
            "}";
    }
}
