package com.els.tso.system.query;


import com.els.tso.base.core.entity.BaseQuery;

/**
 * <p>
 * 公司、部门组织表查询
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
public class OrganizationQuery extends BaseQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 父级组织id
     */
    private Long parentId;

    /**
     * 组织类别
     */
    private Long catalogId;

    /**
     * 顺序号
     */
    private Integer order;

    /**
     * 是否禁用(0未禁用,1禁用)
     */
    private Boolean disabled;


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getCatalogId() {
        return catalogId;
    }

    public void setCatalogId(Long catalogId) {
        this.catalogId = catalogId;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Organization{" +
            "orgCode=" + orgCode +
            ", orgName=" + orgName +
            ", parentId=" + parentId +
            ", catalogId=" + catalogId +
            ", order=" + order +
            ", disabled=" + disabled +
            "}";
    }
}


