package com.els.tso.system.query;


import com.baomidou.mybatisplus.annotation.TableField;
import com.els.tso.base.core.entity.BaseQuery;

/**
 * <p>
 * 岗位表查询
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
public class PostQuery extends BaseQuery {

    private static final long serialVersionUID = 1L;

    private Long organizationId;

    /**
     * 岗位编码
     */
    private String postCode;

    /**
     * 岗位名称
     */
    private String postName;

    /**
     * 上级岗位id
     */
    private Long parentId;

    /**
     * 是否负责人岗位(1负责人,0普通岗位)
     */
    @TableField("is_leader")
    private Boolean leader;

    /**
     * 顺序号
     */
    private Integer order;

    /**
     * 是否禁用(0未禁用,1禁用)
     */
    private Boolean disabled;


    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeader() {
        return leader;
    }

    public void setLeader(Boolean leader) {
        this.leader = leader;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Post{" +
            "organizationId=" + organizationId +
            ", postCode=" + postCode +
            ", postName=" + postName +
            ", parentId=" + parentId +
            ", leader=" + leader +
            ", order=" + order +
            ", disabled=" + disabled +
            "}";
    }
}


