package com.els.tso.system.query;


import com.baomidou.mybatisplus.annotation.TableField;
import com.els.tso.base.core.entity.BaseQuery;

/**
 * <p>
 * 员工档案表查询
 * </p>
 *
 * @author XX
 * @since 2021-01-14
 */
public class StaffQuery extends BaseQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 岗位id
     */
    private Long postId;

    /**
     * 员工工号
     */
    private String staffNumber;

    /**
     * 员工姓名
     */
    private String staffName;

    /**
     * 是否主要岗位(1主岗,2兼职)
     */
    @TableField("is_main_post")
    private Boolean mainPost;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 男1,女2
     */
    private Integer sex;

    /**
     * 在职1(不包含试用期员工),离职2,实习3,试用4
     */
    private Integer jobStatus;

    /**
     * 是否禁用(0未禁用,1禁用)
     */
    private Boolean disabled;


    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getStaffNumber() {
        return staffNumber;
    }

    public void setStaffNumber(String staffNumber) {
        this.staffNumber = staffNumber;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public Boolean getMainPost() {
        return mainPost;
    }

    public void setMainPost(Boolean mainPost) {
        this.mainPost = mainPost;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(Integer jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Boolean getDisabled() {
        return disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public String toString() {
        return "Staff{" +
            "postId=" + postId +
            ", staffNumber=" + staffNumber +
            ", staffName=" + staffName +
            ", mainPost=" + mainPost +
            ", email=" + email +
            ", phone=" + phone +
            ", sex=" + sex +
            ", jobStatus=" + jobStatus +
            ", disabled=" + disabled +
            "}";
    }
}


