package com.els.tso.common.dto;

import com.els.tso.common.constant.ResultEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 返回DTO
 *
 * @author lqs
 * @since 2020-08-04
 */
@Setter
@Getter
@ToString
public class R<T> implements Serializable {

    private static final long serialVersionUID = 130L;

    /**
     * 状态
     */
    private String code;
    /**
     * 消息
     */
    private String message;
    /**
     * 返回数据
     */
    private T data;

    /**
     * 系统默认成功返回
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> R<T> ok(T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_SUCCESS.getCode());
        dto.setMessage(ResultEnum.DEFAULT_RESULT_SUCCESS.getMessage());
        return dto;
    }

    public static <T> R<T> ok() {
        return ok(null);
    }

    /**
     * 系统默认失败返回
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> R<T> fail(T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_FAIL.getCode());
        dto.setMessage(ResultEnum.DEFAULT_RESULT_FAIL.getMessage());
        return dto;
    }


    /**
     * 自定义失败返回
     *
     * @param code
     * @param message
     * @param data
     * @param <T>
     * @return
     */
    public static <T> R<T> fail(String code, String message, T data) {
        R<T> dto = new R<>();
        dto.setData(data);
        dto.setCode(code);
        dto.setMessage(message);
        return dto;
    }

    /**
     * 自定义失败返回
     *
     * @param message
     * @param data
     * @param <T>
     * @return
     */
    public static <T> R<T> fail(String message, T data) {
        R<T> dto = new R<>();
        dto.setData(data);
        dto.setCode(ResultEnum.BUSINESS_RESULT_FAIL.getCode());
        dto.setMessage(message);
        return dto;
    }

    /**
     * 自定义成功返回
     *
     * @param message
     * @param data
     * @param <T>
     * @return
     */
    public static <T> R<T> ok(String message, T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_SUCCESS.getCode());
        dto.setMessage(message);
        return dto;
    }
}
