package com.els.tso.common.util;


import com.els.tso.common.dto.UserPrincipal;

/**
 * @author daipj
 * @date 2020/10/23 14:56
 */
public class AuthPrincipalHolder {

    private final static ThreadLocal<UserPrincipal> USER_THREAD_LOCAL = new ThreadLocal<>();

    public static UserPrincipal getUser() {
        return USER_THREAD_LOCAL.get();
    }

    public static void setUser(UserPrincipal userPrincipal) {
        USER_THREAD_LOCAL.set(userPrincipal);
    }

    public static void remove() {
        USER_THREAD_LOCAL.remove();
    }

}
