package com.els.tso.common.util;


import com.els.tso.common.bo.PictureVerificationCodeBO;
import com.els.tso.common.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Random;

/**
 * 生产验证码
 *
 * @author daipj
 */
public class PictureUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(PictureUtil.class);

    private static final int IMG_WIDTH = 85;
    private static final int IMG_HEIGHT = 35;
    private static final int CODE_COUNT = 4;
    private static final String FORMAT_NAME = "JPEG";
    private static final String FONT_STYLE = "Times New Roman";
    private static final int FONT_HEIGHT;
    private static final int CODEY;
    private static int x;

    /**
     * 初始化配置参数
     */
    static {

        x = IMG_WIDTH / (CODE_COUNT + 1);
        FONT_HEIGHT = IMG_HEIGHT - 2;
        CODEY = IMG_HEIGHT - 12;
    }

    /**
     *
     */
    public static PictureVerificationCodeBO generateVerificationCode() {

        // 在内存中创建图象
        BufferedImage image = new BufferedImage(IMG_WIDTH, IMG_HEIGHT, BufferedImage.TYPE_INT_RGB);

        // 获取图形上下文
        Graphics2D g = image.createGraphics();

        // 生成随机类
        Random random = new Random();

        // 设定背景色
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, IMG_WIDTH, IMG_HEIGHT);

        // 设定字体
        g.setFont(new Font(FONT_STYLE, Font.PLAIN + Font.ITALIC, FONT_HEIGHT));

        // 画边框
        g.setColor(new Color(55, 55, 12));
        g.drawRect(0, 0, IMG_WIDTH - 1, IMG_HEIGHT - 1);

        // 随机产生155条干扰线，使图象中的认证码不易被其它程序探测到
        g.setColor(getRandColor(160, 200));
        for (int i = 0; i < 10; i++) {
            int x = random.nextInt(IMG_WIDTH);
            int y = random.nextInt(IMG_HEIGHT);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }

        // 取随机产生的认证码(4位数字)
        StringBuilder sRand = new StringBuilder();
        int red, green, blue;
        for (int i = 0; i < CODE_COUNT; i++) {
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            char retWord = getSingleNumberChar();
            sRand.append(retWord);
            g.setColor(new Color(red, green, blue));
            g.drawString(String.valueOf(retWord), (i) * x, CODEY);

        }

        Base64.Encoder encoder;
        PictureVerificationCodeBO pictureVerificationCodeBO;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            // 输出图象到页面
            ImageIO.write(image, FORMAT_NAME, bos);
            bos.flush();
            encoder = Base64.getEncoder();
            pictureVerificationCodeBO = new PictureVerificationCodeBO(sRand.toString(), encoder.encodeToString(bos.toByteArray()));
        } catch (IOException e) {
            throw new BusinessException("", e);
        }
        //图象释放资源
        g.dispose();
        pictureVerificationCodeBO.setPicContentBase64(encoder.encodeToString(sRand.toString().getBytes(StandardCharsets.UTF_8)));
        return pictureVerificationCodeBO;
    }

    private static Color getRandColor(int fc, int bc) {// 给定范围获得随机颜色
        Random random = new Random();
        int max = 255;
        if (fc > max) {
            fc = max;
        }
        if (bc > max) {
            bc = max;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }


    private static char getSingleNumberChar() {
        Random random = new Random();
        int numberResult = random.nextInt(10);
        int ret = numberResult + 48;
        return (char) ret;
    }


}
