package com.els.tso.common.util;

/**
 * @author daipj
 * @date 2020/11/17 16:49
 */

import com.els.tso.common.bo.PictureCodeQuery;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

/**
 * @author pengjied
 */
public class QrCodeUtil {


    public static void generateQr(PictureCodeQuery condition, OutputStream output) throws WriterException, IOException {

        //设置默认值
        setDefaultValue(condition);
        int width = condition.getWidth();
        int height = condition.getHeight();
        Hashtable<EncodeHintType, String> hints = new Hashtable<>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BarcodeFormat format;
        //默认二维码
        switch (condition.getBarcodeFormat()) {

            case 2:
                format = BarcodeFormat.CODABAR;
                break;
            case 3:
                format = BarcodeFormat.CODE_128;
                break;
            case 4:
                format = BarcodeFormat.AZTEC;
                break;
            default:
                format = BarcodeFormat.QR_CODE;
        }
        BitMatrix bm = new MultiFormatWriter().encode(condition.getContent(), format, width, height, hints);

        BufferedImage image = toImage(bm, condition.getBgColor(), condition.getFgColor());
        //把二维码写到response的输出流
        ImageIO.write(image, condition.getPicFormat(), output);
    }

    private static BufferedImage toImage(BitMatrix bm, int bgColor, int fgColor) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                image.setRGB(x, y, bm.get(x, y) ? fgColor : bgColor);
            }
        }
        return image;
    }

    private static void setDefaultValue(PictureCodeQuery condition) {

        if (StringUtils.isBlank(condition.getPicFormat())) {
            condition.setPicFormat("jpg");
        }
        if (StringUtils.isBlank(condition.getContent())) {
            condition.setContent("请写入数据:");
        }
    }
}
