/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.common.dto;

import com.els.tso.common.constant.ResultEnum;
import java.io.Serializable;

public class R<T>
implements Serializable {
    private static final long serialVersionUID = 130L;
    private String code;
    private String message;
    private T data;

    public static <T> R<T> ok(T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_SUCCESS.getCode());
        dto.setMessage(ResultEnum.DEFAULT_RESULT_SUCCESS.getMessage());
        return dto;
    }

    public static <T> R<T> ok() {
        return R.ok(null);
    }

    public static <T> R<T> fail(T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_FAIL.getCode());
        dto.setMessage(ResultEnum.DEFAULT_RESULT_FAIL.getMessage());
        return dto;
    }

    public static <T> R<T> fail(String code, String message, T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(code);
        dto.setMessage(message);
        return dto;
    }

    public static <T> R<T> fail(String message, T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.BUSINESS_RESULT_FAIL.getCode());
        dto.setMessage(message);
        return dto;
    }

    public static <T> R<T> ok(String message, T data) {
        R<T> dto = new R<T>();
        dto.setData(data);
        dto.setCode(ResultEnum.DEFAULT_RESULT_SUCCESS.getCode());
        dto.setMessage(message);
        return dto;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

