/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.common.util;

import java.net.InetAddress;

public class IdWorker {
    private static final long TWEPOCH = 1361753741828L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long MAX_WORKER_ID = 1023L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final IdWorker WORKER = new IdWorker();
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    @Deprecated
    public IdWorker(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 1023L));
        }
        this.workerId = workerId;
    }

    public IdWorker() {
        this.workerId = IdWorker.getAddress() % 1024L;
    }

    public static long getId() {
        return WORKER.nextId();
    }

    private static long getAddress() {
        try {
            String currentIpAddress = InetAddress.getLocalHost().getHostAddress();
            String[] str = currentIpAddress.split("\\.");
            StringBuilder hardware = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                hardware.append(str[i]);
            }
            return Long.parseLong(hardware.toString());
        }
        catch (Exception exception) {
            return 2L;
        }
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        int i100000 = 100000;
        for (int i = 0; i < i100000; ++i) {
            System.out.println(IdWorker.getId());
        }
        long end = System.currentTimeMillis();
        System.out.println(100000L / (end - start) + "\u4e2a/ms");
        System.out.println(IdWorker.getId());
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            try {
                throw new Exception(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1361753741828L << 22 | this.workerId << 12 | this.sequence;
        return nextId;
    }

    private long tilNextMillis(long lastTimestamp1) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp1) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

